/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.container;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public abstract class ContainerFillingRecipe
implements ICastingRecipe,
IMultiRecipe<DisplayCastingRecipe> {
    protected final class_3956<?> type;
    protected final class_2960 id;
    protected final String group;
    protected final int fluidAmount;
    protected final class_1792 container;
    private List<DisplayCastingRecipe> displayRecipes = null;

    private static Optional<Storage<FluidVariant>> getFluidHandlerItem(class_1799 stack) {
        return Optional.ofNullable((Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack)));
    }

    @Override
    public long getFluidAmount(ICastingContainer inv) {
        FluidVariant fluid = FluidVariant.of((class_3611)inv.getFluid());
        try (Transaction tx = TransferUtil.getTransaction();){
            long l = ContainerFillingRecipe.getFluidHandlerItem(inv.getStack()).map(handler -> StorageUtil.simulateInsert((Storage)handler, (Object)fluid, (long)this.fluidAmount, (TransactionContext)tx)).orElse(0L);
            return l;
        }
    }

    @Override
    public boolean isConsumed() {
        return true;
    }

    @Override
    public boolean switchSlots() {
        return false;
    }

    @Override
    public int getCoolingTime(ICastingContainer inv) {
        return 5;
    }

    public boolean matches(ICastingContainer inv, class_1937 worldIn) {
        class_1799 stack = inv.getStack();
        FluidVariant fluid = FluidVariant.of((class_3611)inv.getFluid());
        try (Transaction tx = TransferUtil.getTransaction();){
            boolean bl = stack.method_7909() == this.container.method_8389() && ContainerFillingRecipe.getFluidHandlerItem(stack).filter(handler -> StorageUtil.simulateInsert((Storage)handler, (Object)fluid, (long)this.fluidAmount, (TransactionContext)tx) > 0L).isPresent();
            return bl;
        }
    }

    @Deprecated
    public class_1799 method_8110(class_5455 registryAccess) {
        return new class_1799((class_1935)this.container);
    }

    public class_1799 assemble(ICastingContainer inv, class_5455 registryAccess) {
        class_1799 stack = inv.getStack().method_7972();
        ContainerItemContext context = ContainerItemContext.withConstant((class_1799)stack);
        return Optional.ofNullable((Storage)FluidStorage.ITEM.find(stack, (Object)context)).map(handler -> {
            try (Transaction tx = TransferUtil.getTransaction();){
                handler.insert((Object)FluidVariant.of((class_3611)inv.getFluid(), (class_2487)inv.getFluidTag()), (long)this.fluidAmount, (TransactionContext)tx);
                tx.commit();
            }
            return context.getItemVariant().toStack((int)context.getAmount());
        }).orElse(stack);
    }

    @Override
    public List<DisplayCastingRecipe> getRecipes() {
        if (this.displayRecipes == null) {
            List<class_1799> casts = Collections.singletonList(new class_1799((class_1935)this.container));
            this.displayRecipes = class_7923.field_41173.method_10220().filter(fluid -> fluid.method_15774() != class_1802.field_8162 && fluid.method_15793(fluid.method_15785())).map(fluid -> {
                FluidStack fluidStack = new FluidStack(fluid, (long)this.fluidAmount);
                class_1799 stack = new class_1799((class_1935)this.container);
                ContainerItemContext context = ContainerItemContext.withConstant((class_1799)stack);
                stack = Optional.ofNullable((Storage)FluidStorage.ITEM.find(stack, (Object)context)).map(handler -> {
                    try (Transaction tx = TransferUtil.getTransaction();){
                        handler.insert((Object)fluidStack.getType(), fluidStack.getAmount(), (TransactionContext)tx);
                        tx.commit();
                    }
                    return context.getItemVariant().toStack((int)context.getAmount());
                }).orElse(stack);
                return new DisplayCastingRecipe(this.method_17716(), casts, Collections.singletonList(fluidStack), stack, 5, true);
            }).toList();
        }
        return this.displayRecipes;
    }

    public ContainerFillingRecipe(class_3956<?> type, class_2960 id, String group, int fluidAmount, class_1792 container) {
        this.type = type;
        this.id = id;
        this.group = group;
        this.fluidAmount = fluidAmount;
        this.container = container;
    }

    public class_3956<?> method_17716() {
        return this.type;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public String method_8112() {
        return this.group;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public class_1792 getContainer() {
        return this.container;
    }

    public static class Table
    extends ContainerFillingRecipe {
        public Table(class_2960 idIn, String groupIn, int fluidAmount, class_1792 containerIn) {
            super((class_3956)TinkerRecipeTypes.CASTING_TABLE.get(), idIn, groupIn, fluidAmount, containerIn);
        }

        public class_1865<?> method_8119() {
            return (class_1865)TinkerSmeltery.tableFillingRecipeSerializer.get();
        }
    }

    public static class Basin
    extends ContainerFillingRecipe {
        public Basin(class_2960 idIn, String groupIn, int fluidAmount, class_1792 containerIn) {
            super((class_3956)TinkerRecipeTypes.CASTING_BASIN.get(), idIn, groupIn, fluidAmount, containerIn);
        }

        public class_1865<?> method_8119() {
            return (class_1865)TinkerSmeltery.basinFillingRecipeSerializer.get();
        }
    }
}

